/******************************************************************************
 * %Id: gfx_bridge_if.h,v 1.5 2009/01/19 05:01:00 furuta Exp $
 *
 * FileName		:gfx_bridge_if.h
 *
 * Description	:for Bridge(wrapper) I/F Define header
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_GFX_BRIDGE_IF_H_
#define	_GFX_BRIDGE_IF_H_

#include <linux/iosc/gfx_bridge_data.h>

#define GFX_IOC_SETSCREEN                   IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  1 , sizeof(gfx_set_screen_arg_t))
#define GFX_IOC_SETCOLORPALETTE(size)	    IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  2 , (size))
#define GFX_IOC_CONVERTCOLORSPACE           IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  3 , sizeof(gfx_convert_color_space_arg_t))
#define GFX_IOC_VISIBLE                     IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  4 , sizeof(gfx_visible_arg_t))
#define GFX_IOC_INVISIBLE                   IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  5 , sizeof(gfx_invisible_arg_t))
#define GFX_IOC_SETREGION                   IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  6 , sizeof(gfx_set_region_arg_t))
#define GFX_IOC_SWITCHLAYER                 IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  7 , sizeof(gfx_switch_layer_arg_t))
#define GFX_IOC_DRAWBITMAP(size)            IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  8 , (size))
#define GFX_IOC_DRAWBITMAPWITHMASK(size)    IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC,  9 , (size))
#define GFX_IOC_DRAWBITMAPWITHSCALING(size) IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 10 , (size))
#define GFX_IOC_BITBLTCOPY                  IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 11 , sizeof(gfx_bitblt_arg_t))
#define GFX_IOC_BITBLTOVERLAP               IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 12 , sizeof(gfx_bitblt_arg_t))
#define GFX_IOC_FILLRECT                    IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 13 , sizeof(gfx_fill_rect_arg_t))
#define GFX_IOC_DRAWLINE                    IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 14 , sizeof(gfx_draw_line_arg_t))
#define GFX_IOC_GETDRAWSTATUS               IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 15 , sizeof(gfx_get_draw_status_arg_t))
#define GFX_IOC_STORECANVAS                 IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 16 , sizeof(gfx_store_canvas_arg_t))
#define GFX_IOC_DELETECANVAS                IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 17 , sizeof(gfx_delete_canvas_arg_t))
#define GFX_IOC_CREATEIMAGEBUFFER           IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 18 , sizeof(gfx_create_image_buffer_arg_t))
#define GFX_IOC_DESTROYIMAGEBUFFER          IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 19 , sizeof(gfx_destroy_image_buffer_arg_t))
#define GFX_IOC_SETLOSDPOSITION             IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 20 , sizeof(gfx_set_losd_position_arg_t))
#define GFX_IOC_SETLOSDOUTPUTFORMAT         IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 21 , sizeof(gfx_set_losd_output_format_arg_t))
#define GFX_IOC_GETCANVASINFORMATION        IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 22 , sizeof(gfx_get_canvas_information_arg_t))
#define GFX_IOC_GETCVSTBL                   IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 23 , sizeof(gfx_get_cvstbl_arg_t))
#define GFX_IOC_TXTSTRING                   IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 24 , sizeof(gfx_txt_string_arg_t))
#define GFX_IOC_TXTGETAREA                  IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 25 , sizeof(gfx_txt_get_area_arg_t))
#define GFX_IOC_SETCANVASFORMAT             IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 26 , sizeof(gfx_set_canvas_format_arg_t))
#define GFX_IOC_SETCANVASSIZE               IOSC_DEFINE_MMAP_RWCMD(L_GFX_MAGIC, 27 , sizeof(gfx_set_canvas_size_arg_t))
#define GFX_IOC_INIT                        IOSC_DEFINE_RWCMD(L_GFX_MAGIC, 30 , sizeof(gfx_init_arg_t))
#define GFX_IOC_TERM                        IOSC_DEFINE_RWCMD(L_GFX_MAGIC, 31 , sizeof(gfx_term_arg_t))

#define GFX_IOC_SETMMAPCOM                  IOSC_DEFINE_DATA_WRCMD(2, 2 , sizeof(unsigned long))
#define GFX_IOC_GETMMAPCOM                  IOSC_DEFINE_DATA_RDCMD(2, 2 , sizeof(unsigned long))
#define GFX_IOC_SETINTCVS(size)             IOSC_DEFINE_DATA_WRCMD(3, 3 , (size))
#define GFX_IOC_GETINTCVS(size)             IOSC_DEFINE_DATA_RDCMD(3, 3 , (size))

#endif	/* _GFX_BRIDGE_IF_H_ */
/* end of gfx_bridge_if.h */
